/*! Copyright(c) 2008-2015 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 *\file		wps_monitor.h
 *\brief	wps monitor daemon for MTK.	
 *
 *\author	chencanjie <chencanjie@tp-link.net>
 *\version	1.0
 *\date		2015/05/04
 *
 *\history \arg	1.0, 2015/05/04, chencanjie, Create the file. 
 */
 
#ifndef _WPS_MONITOR_H_
#define _WPS_MONITOR_H_

#ifndef BOOL
#define BOOL int
#endif

#ifndef OK
#define OK		0
#endif

#ifndef ERROR
#define ERROR	-1
#endif

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

#define INT16 short
#define INT8 char
#define INT32 int
#define UINT8 unsigned char
#define UINT32 unsigned int
#define UINT16 unsigned short
#define ULONG unsigned long
#define USHORT UINT16

#define WPS_FLAG_SHUTDOWN	0x1

#define WPS_MONITOR_PID_FILE_PATH		"/tmp/wps_monitor.pid"

#define WPS_LOOPBACK_ADDR		"127.0.0.1"
#define WL0_WPS_UI_PORT			40500
#define WL1_WPS_UI_PORT			40510
#define WPSD_WL0_MONITOR_PORT	40520
#define WPSD_WL1_MONITOR_PORT	40530

#define INVALID_SOCKET 			-1

#define WPS_READ_MAX_LEN 		2048

#define WPS_UI_METHOD_PIN		1
#define WPS_UI_METHOD_PBC		2

#define WLAN_2G_STA_IDX			0
#define WLAN_5G_STA_IDX			0
#define WLAN_STA_IDX			0

#define WLAN_2G_AP_IDX			0
#define WLAN_5G_AP_IDX			0
#define WLAN_AP_IDX				0

#define WLAN_STA_2G_IFNAME_FORMAT "apcli%d"
#define WLAN_STA_5G_IFNAME_FORMAT "apclii%d"

#define WLAN_AP_2G_IFNAME_FORMAT "ra%d"
#define WLAN_AP_5G_IFNAME_FORMAT "rai%d"

#define IFNAMESIZ				16
#define WLAN_MAX_BSSID_NUM		4
#define WPS_TIMEOUT_TIMES				120

#define MAX_TIMER_NUM	32

#define RT_OID_WSC_QUERY_STATUS					0x0751

#define RT_PRIV_IOCTL							(SIOCIWFIRSTPRIV + 0x01)

#define SIGNUM_MIN			SIGRTMIN
#define SIGNUM_ADVSEC		(SIGNUM_MIN + 0)
#define SIGNUM_SYSLOG		(SIGNUM_MIN + 1)
#define SIGNUM_RESTORE		(SIGNUM_MIN + 2)
#define SIGNUM_WPS_2G		(SIGNUM_MIN + 3)
#define SIGNUM_WPS_2G_2		(SIGNUM_MIN + 4)
#define SIGNUM_WPS_2G_3		(SIGNUM_MIN + 5)
#define SIGNUM_WPS_2G_4		(SIGNUM_MIN + 6)
#define SIGNUM_WPS_5G		(SIGNUM_MIN + 7)
#define SIGNUM_WPS_5G_2		(SIGNUM_MIN + 8)
#define SIGNUM_WPS_5G_3		(SIGNUM_MIN + 9)
#define SIGNUM_WPS_5G_4		(SIGNUM_MIN + 10)
#define SIGNUM_DYNAMIC_MIN	(SIGNUM_MIN + 11)		// For tpPeriodRun
#define SIGNUM_MAX			SIGRTMAX

// Wsc status code
#define STATUS_WSC_NOTUSED						0
#define STATUS_WSC_IDLE							1
#define STATUS_WSC_FAIL							2		// WSC Process Fail
#define STATUS_WSC_LINK_UP						3		// Start WSC Process
#define STATUS_WSC_EAPOL_START_RECEIVED			4		// Received EAPOL-Start
#define STATUS_WSC_EAP_REQ_ID_SENT				5		// Sending EAP-Req(ID)
#define STATUS_WSC_EAP_RSP_ID_RECEIVED			6		// Receive EAP-Rsp(ID)
#define STATUS_WSC_EAP_RSP_WRONG_SMI			7		// Receive EAP-Req with wrong WSC SMI Vendor Id
#define STATUS_WSC_EAP_RSP_WRONG_VENDOR_TYPE	8		// Receive EAPReq with wrong WSC Vendor Type
#define STATUS_WSC_EAP_REQ_WSC_START			9		// Sending EAP-Req(WSC_START)
#define STATUS_WSC_EAP_M1_SENT					10		// Send M1
#define STATUS_WSC_EAP_M1_RECEIVED				11		// Received M1
#define STATUS_WSC_EAP_M2_SENT					12		// Send M2
#define STATUS_WSC_EAP_M2_RECEIVED				13		// Received M2
#define STATUS_WSC_EAP_M2D_RECEIVED				14		// Received M2D
#define STATUS_WSC_EAP_M3_SENT					15		// Send M3
#define STATUS_WSC_EAP_M3_RECEIVED				16		// Received M3
#define STATUS_WSC_EAP_M4_SENT					17		// Send M4
#define STATUS_WSC_EAP_M4_RECEIVED				18		// Received M4
#define STATUS_WSC_EAP_M5_SENT					19		// Send M5
#define STATUS_WSC_EAP_M5_RECEIVED				20		// Received M5
#define STATUS_WSC_EAP_M6_SENT					21		// Send M6
#define STATUS_WSC_EAP_M6_RECEIVED				22		// Received M6
#define STATUS_WSC_EAP_M7_SENT					23		// Send M7
#define STATUS_WSC_EAP_M7_RECEIVED				24		// Received M7
#define STATUS_WSC_EAP_M8_SENT					25		// Send M8
#define STATUS_WSC_EAP_M8_RECEIVED				26		// Received M8
#define STATUS_WSC_EAP_RAP_RSP_ACK				27		// Processing EAP Response (ACK)
#define STATUS_WSC_EAP_RAP_REQ_DONE_SENT		28		// Processing EAP Request (Done)
#define STATUS_WSC_EAP_RAP_RSP_DONE_SENT		29		// Processing EAP Response (Done)
#define STATUS_WSC_EAP_FAIL_SENT				30		// Sending EAP-Fail
#define STATUS_WSC_ERROR_HASH_FAIL				31		// WSC_ERROR_HASH_FAIL
#define STATUS_WSC_ERROR_HMAC_FAIL				32		// WSC_ERROR_HMAC_FAIL
#define STATUS_WSC_ERROR_DEV_PWD_AUTH_FAIL		33		// WSC_ERROR_DEV_PWD_AUTH_FAIL
#define STATUS_WSC_CONFIGURED					34
#define STATUS_WSC_SCAN_AP						35		// Scanning AP
#define STATUS_WSC_EAPOL_START_SENT				36
#define STATUS_WSC_EAP_RSP_DONE_SENT			37
#define STATUS_WSC_WAIT_PIN_CODE				38
#define STATUS_WSC_START_ASSOC					39
#define STATUS_WSC_IBSS_WAIT_NEXT_SMPBC_ENROLLEE 40

/* All error message starting from 0x0100 */
#define STATUS_WSC_PBC_TOO_MANY_AP				0x0101		// Too many PBC AP avaliable
#define STATUS_WSC_PBC_NO_AP					0x0102		// No PBC AP avaliable
#define STATUS_WSC_EAP_FAIL_RECEIVED			0x0103		// Received EAP-FAIL
#define STATUS_WSC_EAP_NONCE_MISMATCH			0x0104		// Receive EAP with wrong NONCE
#define STATUS_WSC_EAP_INVALID_DATA				0x0105		// Receive EAP without integrity (Hmac mismatch)
#define STATUS_WSC_PASSWORD_MISMATCH			0x0106		// Error PIN Code (R-Hash mismatch)
#define STATUS_WSC_EAP_REQ_WRONG_SMI			0x0107		// Receive EAP-Req with wrong WPS SMI Vendor Id
#define STATUS_WSC_EAP_REQ_WRONG_VENDOR_TYPE	0x0108		// Receive EAPReq with wrong WPS Vendor Type
#define STATUS_WSC_PBC_SESSION_OVERLAP			0x0109		// AP PBC session overlap
#define STATUS_WSC_SMPBC_TOO_MANY_REGISTRAR		0x010a		// Too many SMPBC Registrars avaliable

#define RT_OID_WSC_UUID								0x0753
#define UUID_LEN_STR 37  /* hex to string, plus 4 dash, plus 1 '\0' */

typedef enum wps_status {
	WPS_INPROGRESS = 1,
	WPS_SUCCESS,
	WPS_ERROR,
	WPS_OVERLAP,
	WPS_IDLE
} WPS_STATUS;

typedef enum wps_role {
	WPS_ENROLLEE,
	WPS_REGISTRAR,
} WPS_ROLE;

typedef enum _WPS_ACTION
{
	WPS_ACT_NONE = 0,
	WPS_ACT_START,
	WPS_ACT_STOP,
	WPS_ACT_MAX
}WPS_ACTION;

typedef enum {
	SYS_REPEATER_MODE = 0,
	SYS_AP_MODE,
	SYS_MAX_MODE = SYS_AP_MODE
}SYS_RUN_MODE;

typedef enum {
	WLAN_BAND_MIN = 0,
	WLAN_BAND_2G = 0,
	WLAN_BAND_5G = 1,
	WLAN_BAND_MAX = 1,
	WLAN_BAND_NUM = WLAN_BAND_MAX + 1,
	WLAN_BAND_TEMP = WLAN_BAND_2G,	/* currently support 2G only on upper level */
} WLAN_BAND;

typedef struct wps_ctx {
	WPS_STATUS		status;					/*not used in rpt platform*/
	WPS_ROLE		role;
	BOOL			apConfigured;			/*not used in rpt platform*/
	timer_t			tid;
	BOOL			timerBusy;
	int				wscTimeoutCounter;
	BOOL			wscBusy;
	pthread_t		pid;					/*not used in rpt platform*/
	pthread_mutex_t	mutex;					/*not used in rpt platform*/
} WPS_CTX;

typedef struct _MONITOR_DATA
{
    int band;
	BOOL finished;
	BOOL isFromPinBackground;
	int status;
}MONITOR_DATA;

typedef struct _WPSD_DATA
{
	unsigned int mode;
	unsigned int method;
	unsigned int band;
	unsigned int action;
	BOOL isApConfig;
	unsigned char pinCode[8];
}WPSD_DATA;

typedef void (*sighandler_t)(int);
typedef sighandler_t sighandler;

void _wps_monitor_printf(char* cmd, ...);

extern int wps_dbg_level;

#define wpsDbg(fmt, args...) do { \
	if(wps_dbg_level >= 1)			\
        _wps_monitor_printf("wps_monitor[%s:%d]: " fmt, __func__, __LINE__, ## args); \
} while (0)

#define wpsInfo(fmt, args...) do { \
        _wps_monitor_printf("wps_monitor[%s:%d]: " fmt, __func__, __LINE__, ## args); \
} while (0)	

#define wpsError(fmt, args...) do { \
        _wps_monitor_printf("wps_monitor[%s:%d]: " fmt, __func__, __LINE__, ## args); \
} while (0)	

#endif	/* _WPS_MONITOR_H_ */

